//
//  MCClientStage.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 21/05/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//



#import <MCClientServer/MCClientServerDefines.h>


@class MCSQLiteStore, MCSyncHost, MCStageChangeManager, MCSQLiteContext;

@interface MCClientStage : NSObject {
	
	MCSyncHost *syncHost;
	MCSQLiteStore *clientStore;
	MCStageChangeManager *changeMan;

	NSString *clientID;
	NSString *username;
	NSString *password;
	NSString *directory;
    NSString *deviceName;
	
	MCSReplicaStatus clientStatus;
    
    NSMutableDictionary *settingsDict;

	NSNumber *lockRowNumber;
	BOOL isLocked;
}

@property (nonatomic, retain) MCSyncHost *syncHost;
@property (nonatomic, retain) MCSQLiteStore *clientStore;
@property (nonatomic, retain) MCStageChangeManager *changeMan;

@property (nonatomic, copy) NSString *clientID;
@property (nonatomic, copy) NSString *username;
@property (nonatomic, copy) NSString *password;
@property (nonatomic, readonly, copy) NSString *directory;
@property (nonatomic, copy) NSString *deviceName;

@property (nonatomic, copy) NSNumber *lockRowNumber;

+ (void)setBasePath:(NSString *)aPath;
+ (NSString *)basePath;

- (id)initWithSyncHost:(MCSyncHost *)aHost clientID:(NSString *)anID create:(BOOL)doCreate;
- (id)initWithClientID:(NSString *)anID create:(BOOL)doCreate;

- (BOOL)isEqualToClientStage:(MCClientStage *)otherStage;

- (NSString *)briefDescription;

- (MCSReplicaStatus)clientStatus;
- (void)setClientStatus:(MCSReplicaStatus)newClientStatus;

- (NSString *)clientStatusMessage;

// Derived
- (NSString *)settingsPath;
- (NSMutableDictionary *)settingsDict;
- (id)settingForKey:(NSString *)aKey;
- (void)setSetting:(id)aValue forKey:(NSString *)aKey;
- (void)updateSettingsFromRequest:(NSDictionary *)requestInfo;


/*!
 If we encounter a problem on a stage, we set the last main reason on the settings plist. This way we can easily access where the failure point was.
 */
- (void)recordStageErrorLevel:(MCSStageStateErrorLevel)errorLevel description:(NSString *)errorLevelExplain;
- (void)incrementStageErrorLevelWithDescription:(NSString *)errorLevelExplain;
- (void)clearStageErrorLevel;
- (MCSStageStateErrorLevel)stageStateErrorLevel;


- (NSString *)databaseMirrorPath;
- (BOOL)databaseMirrorExists;
- (MCSQLiteContext *)databaseMirrorContext;
- (BOOL)deleteDatabaseMirror;

/*!
 Checks to see if there is a file by the name "archives_changes" in the base path or base path/account id. The file can be empty. Only checks for it's presense. ChangeManagers can use this flag to determine if changesets should be archived or not.
 */
- (BOOL)shouldArchiveChanges;

- (BOOL)lockStage;
- (void)unlockStage;
- (BOOL)isStageLocked;


- (BOOL)setupAndConnect:(BOOL)doConnect coaleaseWorkingFolders:(BOOL)coalease changeManagerClass:(Class)cmClass;
- (BOOL)setupAndConnect:(BOOL)doConnect coaleaseWorkingFolders:(BOOL)coalease;
- (BOOL)setupAndConnect:(BOOL)doConnect;
- (BOOL)setup; // -setup locks the stage

- (BOOL)openClientDatabase;
- (void)saveDeviceDetails;

@end
